TITLE ATMEM
PAGE	60,78
;
WORD_COUNT	EQU 6000H
;
LF	EQU	0AH
CR	EQU	0DH
;
DOSC_BLOCKMOVE	EQU 87H
DOSF_OUTSTR	EQU  9		; Output string
;
DOSF_DOSVER	EQU 48		; DOS version
DOSF_TERMPROC	EQU 76		; Terminate with error code
;
DOSI_CASSETTE	EQU 15H
DOSI_TERM	EQU 20H		; Program terminate
DOSI_FUNC	EQU 21H		; Perform a function
;
FCB_DRIVE	EQU 0		; Drive number
FCB_FNAME	EQU FCB_DRIVE+1	; File name
;
FCB1	EQU	05CH
FCB2	EQU	06CH
CMDSTR	EQU	080H
;
S0000	SEGMENT
	ASSUME	CS:S0000,DS:S0000,ES:S0000
	ORG	100H
BEGIN:
	MOV	AX,CS
	MOV	DS,AX
	MOV	ES,AX
	MOV	DX,OFFSET TIT_MSG
	MOV	AH,DOSF_OUTSTR
	INT	DOSI_FUNC
	MOV	AH,DOSF_DOSVER
	INT	DOSI_FUNC
	CMP	AL,0
	JZ	DOS1X			; quit if version 1.x
	MOV	BX,OFFSET BUFFER
	MOV	DI,OFFSET BUF_PTR
	CALL	ABS_ADDRESS
	MOV	AH,DOSC_BLOCKMOVE
	MOV	CX,WORD_COUNT
	MOV	SI,OFFSET GDT
	INT	DOSI_CASSETTE
	MOV	AL,0
	MOV	AH,DOSF_TERMPROC
	INT	DOSI_FUNC

DOS1X:
	MOV	DX,OFFSET VER_MSG
	MOV	AH,DOSF_OUTSTR
	INT	DOSI_FUNC
	INT	DOSI_TERM

TIT_MSG DB	'AT Read Extended Memory Program by B. Whitnall, V1.0'
	DB	CR,LF,'$'
VER_MSG DB	'Needs DOS V2.0 or later$'

; routine to convert Segment:Offset into 3 byte address
; On entry DS=segment,BX=offset,ES:DI ptr to address byte 0

ABS_ADDRESS	PROC	NEAR
	PUSH	AX
	PUSH	CX
	PUSH	DX
	PUSH	DI
	MOV	AX,DS
	MOV	CX,AX
	MOV	AX,16
	MUL	CX			; convert segment address
	ADD	AX,BX			; then add offset
	ADC	DX,0
	STOSB				; save byte to ptr
	MOV	AL,AH
	STOSB
	MOV	AL,DL
	STOSB
	POP	DI
	POP	DX
	POP	CX
	POP	AX
	RET
ABS_ADDRESS	ENDP

PARA_SITE	LABEL NEAR
PARA_SPAN	EQU	PARA_SITE - BEGIN

IF	PARA_SPAN MOD 16
	ORG	(PARA_SITE + 16) - (PARA_SPAN MOD 16)
ENDIF

GDT:	DB	16 DUP (0)

	DW	WORD_COUNT*2		; Source
	DB	80H,12H,10H		; Address 101280h, first dir entry
	DB	93H
	DB	0,0

	DW	WORD_COUNT*2		; Destination
BUF_PTR DB	00H,00h,06H		; Address 060000h, changed to BUFFER
	DB	93H
	DB	0,0

	DB	16 DUP(0)

PAGE_SITE	LABEL NEAR
PAGE_SPAN	EQU	PAGE_SITE - BEGIN

IF	PAGE_SPAN MOD 256
	ORG	(PAGE_SITE + 256) - (PAGE_SPAN MOD 256)
ENDIF

BUFFER:
;	DW	WORD_COUNT DUP (?)
S0000	ENDS
	END	BEGIN
